srctree=$1
objtree=$2
suffix=$3

#!/bin/sh
rm -Rf ${objtree}/u-boot.bin.mz
rm -Rf ${objtree}/u-boot.bin.xz

${srctree}/mz c ${objtree}/u-boot.bin ${objtree}/u-boot.bin.mz
xz -z -k ${objtree}/u-boot.bin
ms_ver="$(strings -a -T binary ${objtree}/u-boot.bin | grep 'MVX' | grep 'UBT1501' | sed 's/\\*MVX/MVX/g' | cut -c 1-32)"

#out_file=u-boot.img.bin
out_file_mz=u-boot${suffix}.mz.img.bin
out_file_xz=u-boot${suffix}.xz.img.bin
out_file=u-boot${suffix}.img.bin
if [ `echo $ms_ver | grep -c "MVX1S" ` -gt 0 ];then
  out_file_mz=u-boot_S.mz.img.bin
  out_file_xz=u-boot_S.xz.img.bin
fi

echo ""
echo $out_file_mz
echo ${srctree}/mkimage -A arm -O u-boot -C mz -a 0 -e 0 -n "$(echo $ms_ver)" -d ${objtree}/u-boot.bin.mz "${objtree}/${out_file_mz}"
${srctree}/mkimage -A arm -O u-boot -C mz -a 0 -e 0 -n "$ms_ver" -d ${objtree}/u-boot.bin.mz "${objtree}/${out_file_mz}"
rm -Rf u-boot.bin.mz
echo ""

echo ""
echo $out_file_xz
echo ${srctree}/mkimage -A arm -O u-boot -C xz -a 0 -e 0 -n "$(echo $ms_ver)" -d ${objtree}/u-boot.bin.xz "${objtree}/${out_file_xz}"
${srctree}/mkimage -A arm -O u-boot -C lzma -a 0 -e 0 -n "$ms_ver" -d ${objtree}/u-boot.bin.xz "${objtree}/${out_file_xz}"
rm -Rf u-boot.bin.xz
echo ""

echo ""
echo $out_file
echo ./mkimage -A arm -O u-boot -C none -a 0 -e 0 -n "$(echo $ms_ver)" -d u-boot.bin "$out_file"
${srctree}/mkimage -A arm -O u-boot -C none -a 0 -e 0 -n "$ms_ver" -d u-boot.bin "$out_file"
echo ""
